#include  <stdio.h>
#include  <malloc.h>
#include  <string.h>
#include  <time.h>
#define SPOOLSIZE   0xff00L/* obt@ */


#ifdef	__LARGE__
#include  <process.h>		/* exit() */
#endif

#ifdef	FLAT
#include  <process.h>		/* exit() */
#endif

/***  vg^Cv錾@***/
void  spool_init(void);
char *xstrdup(char *s);
char *xstrpdup(char *s);
char *xmalloc(long size);
void  get_new_heap(void);
char *timedate_string(time_t lstamp);
char *dump_hex16(unsigned char *data,int mode);
int   printc1(int c);
int   is_kanji1(int c);
int   is_kanji2(int c);


#ifdef  LINUX
int stricmp(char *s,char *t)
{
    while(*s){
      if(toupper(*s)!=toupper(*t)) return -1;
      s++;t++;
    }
    return *t;
}
#endif

#ifdef  CYGWIN
int stricmp(const char *s,const char *t)
{
    while(*s){
      if(toupper(*s)!=toupper(*t)) return -1;
      s++;t++;
    }
    return *t;
}
#endif

char   *spool;                  /* v[̈     */
char   *splp;					/* v[̈̎gp|C^ */
/**********************************************************************
 *  
 **********************************************************************
 */
void	spool_init(void)
{
        splp=spool;
}
/**********************************************************************
 *  btH[}bg̕𕶎obt@ɕۑ
 **********************************************************************
 */
char *xstrdup(char *s)
{
        char *p;

/*      printf("xstrdup(%s)=%lx",s,splp);
 */
        strcpy(splp,s);
        p=splp;
        splp+=strlen(p)+1;
        if(splp>=(spool+SPOOLSIZE-256)) {
        		get_new_heap();
        }
        return p;
}
/**********************************************************************
 *  otH[}bg̕𕶎obt@ɕۑ
 **********************************************************************
 */
char *xstrpdup(char *s)
{
        int n;
        char *p;
        p=splp;

                        n = *s++;n&=0xff;
        while(n) {*splp++ = *s++;n--;}
        *splp++ = 0;

        if(splp>=(spool+SPOOLSIZE-256)) {
        		get_new_heap();
        }
        return p;
}

/**********************************************************************
 *  xmalloc(size)  iG[`FbNt farmalloc j
 **********************************************************************
 */
char *xmalloc(long size)
{
        char *p;
#ifdef	__LARGE__
        p=farmalloc(size);if(p==NULL) {
                printf("[mۂɎs܂.\n");
                exit(1);
        }
#else
        p=malloc(size);if(p==NULL) {
                printf("[mۂɎs܂.\n");
                exit(1);
        }
#endif
        return p;
}

void	get_new_heap()
{
#ifdef	__LARGE__
        spool=farmalloc(SPOOLSIZE);if(spool==NULL) {
                printf("obt@I[o[܂.\n");
                exit(1);
        }
#else
        spool=malloc(SPOOLSIZE);if(spool==NULL) {
                printf("obt@I[o[܂.\n");
                exit(1);
        }
#endif
        splp=spool;
}

/**********************************************************************
 *  
 **********************************************************************
 */
static char buf[64];
char *timedate_string(time_t lstamp)
{
	char *p;
	p = ctime(&lstamp);
	
	strcpy(buf,"???");	//̕.
	
	if(p!=NULL) {		// ctime̖߂lNULLłȂ.
		if(*p != 0) {	// 񂪗oCgłȂ.
			strcpy(buf, p);buf[ strlen(buf)-1 ] = 0;	//Ō̂P.
		}
	}
	return &buf[0];
}


char *dump_hex16(unsigned char *data,int mode)
{
	static	int	sjis1=0;
	int i,c;
	char *p;
	unsigned long *l;
	unsigned char *b;

	p = buf;
	if(mode==1) {
		l=(unsigned long *)data;
		for(i=0;i<16;i+=4) {
			p += sprintf(p,"%08lx ",*l++);
		}
	}else{
		b=data;
		for(i=0;i<16;i++) {
			p += sprintf(p,"%02x ",*b++);
		}
	}

	for(i=0;i<16;i++) {
		c = *data++;
		if(sjis1) {		/*̕PoCg*/
			if(is_kanji2(c)) {
				*p++ = sjis1;			/*  */
				*p++ = c;
			}else{
				*p++ = printc1(sjis1);	/* ANK 2byte */
				*p++ = printc1(c);
			}
			sjis1=0;
		}else{
			if(is_kanji1(c)) {
				sjis1=c;
			}else{
				*p++ = printc1(c);
			}
		}
	}
	*p = 0;
	return buf;
}

int printc1(int c)
{
	if(  c< 0x20 )  c='.';
	if( (c>=0x7f ) && (c<0xa0) ) c='.';
	if( (c>=0xe0 ) ) c='.';
	return c;
}


int	is_kanji1(int c)
{
	if( (c>= 0x81)&&(c<0xa0) ) return(1);
	if( (c>= 0xe0)&&(c<0xf0) ) return(1);
	return(0);
}

int is_kanji2(int c)
{
	if( (c>= 0x40)&&(c<0x7f) ) return(1);
	if( (c>= 0x80)&&(c<0xfd) ) return(1);
	return(0);
}

