/**********************************************************************
 *  vliv̂߂ __mainj for Win16 / Win32s
 **********************************************************************
 */

/*
 *  dosunix̃R}hWindows(comwin)œ߂̃KChF
 *         iBorland-C++ 3.1 / 4.0gpꍇj
 *
 *  (1) WinMain() main(argc,argv) ĂяôŁAmain()
 *      ̎dldoŝ̂Ɠok.(wildcardWJL)
 *      (TDW.exe main֐΂Gg[ƊႢ̂
 *      TDWgꍇmain̖OCmainɕςقǂ܂)
 *
 *  (2) printf(),fprintf(),putchar(),getchar(),exit()Ȃǂ̂܂
 *      ɂĂƉ\Ȃ(PC98̏ꍇ)ƂAVGAOtBbN
 *      ɕ\ꂽ肷̂ŁAcwin_* ɕϊB
 *      (winmain.h ɂ #definegĕϊĂ܂B)
 *      (b̕WCû̂u邩ADIɃN
 *       CuƂĎ̂łAbn̍\ɂ܂
 *       ɂꂷ邱ƂɂȂ̂ŁA\ʓI#defineŒu
 *       ƂȎig܂B)
 *
 *  (3) ̑ADOS̃[NĂADOSint xx𗘗pĂA
 *      PSP̃[NQƂĂ铙A׈ȕ͏KvłB
 *
 *  (4) unix\[Xł́Aƃ|C^̃TCY32bitȂ߂ɁA
 *      ( NULL ƏƂ 0ɂĂ)܂ɂ
 *      ̂ŁAׂĂ̊֐vg^Cv錾邩AB
 *
 *  (5) dos small model̃R[hŁA֐vg^Cv錾ĂȂ
 *      \[Xlarge modelƂɁA|C^ÖقintɌȂ
 *      \ꍇB
 *      ꉞdoslarge modelɑΉĂڐAƂ悢B
 *
 *  (6) unix\[Xł́ATCY32bitv̂̂ŁA
 *      int ---> long ɏȂƓȂ̂B(Win16)
 *
 *  (7) 64kBȏ̔zTCYv̂hugeȃ|C^ɏB
 *      (Win16)
 *
 *
 *  ̑_F
 *      dosp̃Cu(malloc,fopen,fread ...)Windowsŗp
 *      ̂͊댯ȂƂmȂB
 *      WinMainłȂSĂ̏sreturnƂ̂Windows
 *      ̃VXe猩ꍇ͖肪邩ȂB
 */

#include <windows.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include <alloc.h>

#define WILD_ARGS   1   /* 1̎AChJ[hWJB */
#define VBUFSIZ 0x4000	/* stdout(file)邽߂̃obt@TCY*/
#define	FGETSIZE 768
/**********************************************************************
 *  bvh֐
 **********************************************************************
 */
int   FAR PASCAL Puts(LPSTR);
LPSTR FAR PASCAL Gets(LPSTR);

/**********************************************************************
 *  mnobt@
 **********************************************************************
 */

int      Argc;			/* ̌ */
char    *Argv[2048];	/* Xg */

/**********************************************************************
 *  vlŗL̃[N
 **********************************************************************
 */
static  char    *xstrdup(char *);
static  char    *xmalloc(int);

#define SIZE    80

static  int     istty;
static  jmp_buf jumper;
static  char    myname[128];
static  HANDLE  PrevInstance;
static  int     CmdShow;
static	int		exit_code = 0;
/**********************************************************************
 *  փW[[N
 **********************************************************************
 */

/*obt@\*/
typedef struct IO_BUFFER {
	int	  bsize;		// obt@TCY
	int	  len;			// ~ϒ̕
	int   flag;			// 0:X[  1:obt@OL
	int   dirty;		// 
	FILE *fp;			// X[̏ꍇ̃I[vt@C
	char *buffer;		// mۂĂobt@
	char *curp;			// ݏݒ̃|Cg
} IO_BUFFER;

IO_BUFFER cwin_inp;		// cwin stdin  obt@
IO_BUFFER cwin_out;		// cwin stdout obt@
IO_BUFFER cwin_err;		// cwin stderr obt@
char	 prnbuff[4096];	// vsprintfgobt@


/**********************************************************************
 *  vlij
 **********************************************************************
 */
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                   LPSTR lpszCmdParam, int nCmdShow)
{
    int   nargs;
    char  *args[SIZE];
    char  namebuf[SIZE];
    char  *s;
    int   i,retval;
    char  *openmode;

//	Puts(lpszCmdParam);

    /* ͓̑ɈӖ͂Ȃ. */
    PrevInstance = hPrevInstance;
    CmdShow      = nCmdShow;

#ifdef	__FLAT__
	Argc    = 0;	/* Win32sł́Ĉargv[0]CmdParamɊ܂܂悤. */
#else
	/* Win16ł́COargv[0]擾.        */
    /* OĩpXjArgv[0]ɓ. */
 	GetModuleFileName(hInstance,myname,sizeof(myname));
    Argv[0] = myname;
 	Argc    = 1;
#endif	//__FLAT__

	/* CmdParam 󔒂ŋ؂. */
	nargs   = split_args(lpszCmdParam,args);

	cwin_init();
    /* _CNg𒲂ׂ. */
    i=0;
    istty=1;
    while (i < nargs) {
        s = args[i++];
        if(*s == '>') {
            if(s[1]=='>') {s++;openmode="at";}	// 
            else          {    openmode="wt";}	// 
            if(s[1]) {
                if(set_redirect(&cwin_out,s+1      ,openmode)) return 1;
            }else{
                if(set_redirect(&cwin_out,args[i++],openmode)) return 1;
            }
        }else
        if(*s == '<') {
            if(s[1]) {
                if(set_redirect(&cwin_inp,s+1      ,"rt")) return 1;
            }else{
                if(set_redirect(&cwin_inp,args[i++],"rt")) return 1;
            }
        }else{
	/* ChJ[h̓WJsȂ */
#if WILD_ARGS
            if( is_wild(s)) {   //ChJ[h̓WJ
                if(setfiles(s)==0) {
                    sprintf(prnbuff,"[%s]Ƀ}b`t@C͂܂.",s);
                    Puts(prnbuff);
                    return (1);
                }
                while(files(namebuf)) {
                    Argv[Argc++] = xstrdup(namebuf);
                }
            }else
#endif
	/* ChJ[hłȂ͂̂܂ */
                Argv[Argc++] = s;
        }
    }
    Argv[Argc]=NULL;            /* ʖډ */


    retval = setjmp( jumper );	/* exit()΍ */
    if(retval == 0) {			/* setjmp[ȊOȂlongjumpĂƂ*/
        main(Argc,Argv);        /* ʂ main() Ăяo */
    }
    cwin_close();
    return exit_code;
}

/**********************************************************************
 *  փW[
 **********************************************************************
 *	cwin_putchar(c)
 *	cwin_putc(c,fp)
 *	cwin_printf(fmt,arg...)
 *	cwin_fprintf(fmt,arg...)
 *	cwin_exit( exitcode )
 **********************************************************************
 *  stdout-->Puts obt@邽߂̃[`
 **********************************************************************
 *	cwin_init()				stdout obt@
 *  cwin_close()			stdout obt@
 *	cwin_printflush()		stdout obt@tbV
 *  set_redirect(iobuf,str,mode)   _CNgݒ肷
 *	cwin_enqueue(iobuf,c)	   c  stdout out
 *	cwin_enqstr(iobuf,str)	 strstdout out
 **********************************************************************
 *	cwin_setiobuf(iobuf)	iobufmۂ
 *	cwin_clrbuf(iobuf)		iobufɂ
 *	cwin_flushbuf(iobuf)	iobuftbV
 *	cwin_closefile(iobuf)	iobufŃI[vt@CN[Y
 **********************************************************************
 *	obt@pӂ闝R
 *	Eputs()֐'\n't̂'\n'܂ŕ𗭂߂
 *    KvLB܂Asputs()sɕB
 *  E_CNgĂꍇAł
 *	obt@̎
 *	  stdout
 *	  stderr
 *    ̂Q.
 */

/**********************************************************************
 *  
 **********************************************************************
 */
char *Gets_without_CR(char *s)
{
	char *r;
	r = (LPSTR) Gets( (LPSTR) s);
	if(r == NULL)  return r;         // GetsɎsAEOFɓB
	if(*s== 0x1a)  return NULL;      // ^Z[EOF]Ɖ߂Ă܂
}

/**********************************************************************
 *  
 **********************************************************************
 */
char *Gets_with_CR(char *s)
{
	char *r;
	r = (LPSTR) Gets( (LPSTR) s);
	if(r == NULL)  return r;         // GetsɎsAEOFɓB
	if(*s== 0x1a)  return NULL;      // ^Z[EOF]Ɖ߂Ă܂
	strcat(s,"\n");return r;         // ̊֐ \n t܂D
}

/**********************************************************************
 *  >  >> ̌ɏꂽt@CI[vB
 **********************************************************************
 */
int set_redirect(IO_BUFFER *iobuf,char *s,char *mode)
{
	char *vbuf;
    iobuf->fp=fopen(s,mode);
    if( iobuf->fp==NULL) {
        Puts("_CNgɎs܂.");
        return 1;
    }
    istty = 0;
    iobuf->flag=1;

#if	VBUFSIZ		//_CNg̍
	if(*mode!='r') {
		vbuf=xmalloc(VBUFSIZ);
		setvbuf(iobuf->fp,vbuf,0,VBUFSIZ);
	}
#endif

    return 0;
}


cwin_close()
{
    cwin_printflush();
    cwin_closebuf();
}


/**********************************************************************
 *  obt@OW[
 **********************************************************************
 */

cwin_clrbuf( IO_BUFFER *iobuf )			/* obt@ɂ */
{
	iobuf->len    = 0;
	iobuf->dirty  = 0;
	iobuf->curp   =	iobuf->buffer;
}

cwin_setiobuf( IO_BUFFER *iobuf, int bufsize )	/* obt@mۂ */
{
	iobuf->bsize  = bufsize;
	iobuf->buffer =	xmalloc(bufsize+4);
	iobuf->fp     = NULL;
	cwin_clrbuf( iobuf );
}

cwin_closefile( IO_BUFFER *iobuf )		/* I[vt@CN[Y */
{
	if( iobuf->fp != NULL ) fclose( iobuf->fp );
}

cwin_flushbuf( IO_BUFFER *iobuf )		/* obt@tbV */
{
	if( iobuf->dirty ) {
		*(iobuf->curp) = 0;

	  if(iobuf->flag==0) {
		Puts(iobuf->buffer);
        if( ( GetKeyState( VK_CANCEL  )<0 ) ||
           (( GetKeyState( VK_CONTROL )<0 )&&( GetKeyState('C')<0 ) )
          ) {
		    cwin_clrbuf( iobuf );
            Puts("^C");
            cwin_exit(1);
        }
      }else{
      	fprintf(iobuf->fp,"%s\n",iobuf->buffer);
      }
		cwin_clrbuf( iobuf );
	}
}

cwin_enqueue( IO_BUFFER *iobuf , int c)
{
	iobuf->dirty = 1;
	if( c == '\n' )  cwin_flushbuf( iobuf );
	else {
		 *(iobuf->curp)++ = c;
		   iobuf->len  ++;
		if(iobuf->len >= iobuf->bsize ) {
			cwin_flushbuf( iobuf );
		}
	}
}

cwin_enqstr( IO_BUFFER *iobuf , char *s)
{
	int len=0;
	while(*s) {
		cwin_enqueue( iobuf , *s);
		s++;
		len++;
	}
	return len;
}

cwin_init()
{
	cwin_setiobuf( &cwin_out ,4096);	// stdout p Ps̍őTCY=4096
	cwin_setiobuf( &cwin_err ,4096);	// stderr p
	cwin_inp.fp   = NULL;
}

cwin_printflush()
{
	cwin_flushbuf( &cwin_out );
	cwin_flushbuf( &cwin_err );
}

cwin_closebuf()
{
	cwin_closefile( &cwin_out );
	cwin_closefile( &cwin_err );
	cwin_closefile( &cwin_inp );
}

/**********************************************************************
 *  printf()̑
 **********************************************************************
 */
int cwin_printf(char *fmt,int arg1,...)
{
    vsprintf(prnbuff,fmt,&arg1);
	return cwin_enqstr( &cwin_out , prnbuff);
}

/**********************************************************************
 *  fprintf(stderr,...)̑
 **********************************************************************
 */
int cwin_fprintf(FILE *fp,char *fmt,int arg1,...)
{
    int n;
	if(fp==stdout) {
	    vsprintf(prnbuff,fmt,&arg1);
		return cwin_enqstr( &cwin_out , prnbuff);
	}
	if(fp==stderr) {
	    vsprintf(prnbuff,fmt,&arg1);
		return cwin_enqstr( &cwin_err , prnbuff);
	}
	//else!
	    n=vsprintf(prnbuff,fmt,&arg1);
		fprintf(fp,"%s",prnbuff);
		return n;
}

/**********************************************************************
 *  putchar(c)̑
 **********************************************************************
 */
int cwin_putchar(int c)
{
	return cwin_enqueue( &cwin_out , c);
}

/**********************************************************************
 *  putc(c,fp)̑ցi͒x̂stdout,stderrȊO͎gȂق悢j
 **********************************************************************
 */
int cwin_putc(int c,FILE *fp)
{
	if(fp==stdout) {
		return cwin_enqueue( &cwin_out , c);
	}
	if(fp==stderr) {
		return cwin_enqueue( &cwin_err , c);
	}
	putc(c,fp);
}

/**********************************************************************
 *  exit()̑
 **********************************************************************
 */
cwin_exit( rval )
{
	exit_code = rval;
    longjmp( jumper , 1 );
}

/**********************************************************************
 *  puts()̑
 **********************************************************************
 */
cwin_puts( char *s )
{
	if( (cwin_out.fp == NULL)||(cwin_out.fp == NULL) ) {
		return Puts( s );
	}
    return fputs( s , cwin_out.fp);
}

/**********************************************************************
 *  gets()̑
 **********************************************************************
 */
char *cwin_gets( char *buf )
{
	char *r;
	int   l;
	if( (cwin_inp.fp == NULL)||(cwin_inp.fp == stdin ) ) {
		return Gets_without_CR( buf );
	}
    r = fgets( buf , FGETSIZE , cwin_inp.fp);
	if(r==NULL) 
		return r;

	l = strlen(buf); if(l) buf[l-1] = 0;
		return r;
}

/**********************************************************************
 *  fputs()̑
 **********************************************************************
 */
cwin_fputs( char *s , FILE *fp)
{
	if( fp == stdout) {								// Wo͓͂ʈ
		if (cwin_out.fp == NULL) {
			return Puts( s );						// R\[out
		}else{
		    return fputs( s , cwin_out.fp);			// _CNgout
		}
	}
    return fputs( s , fp);							// t@Cout
}

/**********************************************************************
 *  fgets()̑
 **********************************************************************
 */
char *cwin_fgets( char *buf , int max , FILE *fp)
{
	if( fp == stdin ) {								// W͓͂ʈ
		if(cwin_inp.fp == NULL) {
			return Gets_with_CR( buf );				// R\[in
		}else{
		    return fgets( buf , max , cwin_inp.fp);	// _CNgin
		}
	}
    return fgets( buf , max , fp);					// t@Cin
}

/**********************************************************************
    t@C
 **********************************************************************
int setfiles( wildcard )    ChJ[hw肷Bit@C݂ΐ^j
                ߂l𖳎Ďfiles()Ăł悢B

int files( &namebuf )   t@CB      it@C݂ΐ^j
                t@C namebuf ɕԂB


*/

struct  ffblk   dirblk;
static  int     atr = FA_DIREC;
static  int     firstfind=0;
static  char    dirname[80];
static  char    drivename[80]="";

/*************************************************************************
 *  setfiles( wildcard )    ChJ[hw肷Bit@C݂ΐ^j
 *              ߂l𖳎Ďfiles()Ăł悢B
 */
setfiles( char *wildcard )
{
    firstfind=0;

    strcpy(dirname,wildcard);
    delname(dirname);
    if(dirname[1]==':') {
        strcpy(drivename,dirname);
        drivename[2]=0;
    }
    
    if( findfirst( wildcard ,&dirblk,atr)== 0) {    /*  */
        firstfind=1;
        return(1);
    }
    return(0);
}

/*********************************************************************
 *  files( &namebuf )   t@CB      it@C݂ΐ^j
 *              t@C namebuf ɕԂB
 */
files( char *namebuf )
{
    if(firstfind==0) return(0);     /* AȂ */
    
    if(firstfind==1) {
        firstfind=2;
        strcpy(namebuf,dirname);
        strcat(namebuf,dirblk.ff_name);
        return(1);
    }

    if(findnext(&dirblk)== 0) {
        strcpy(namebuf,dirname);
        strcat(namebuf,dirblk.ff_name);
        return(1);
    }

    return(0);
}

/**********************************************************************
 *  t@C폜ăpX{ɂB
 **********************************************************************
 */
/*
 *  pX܂܂ĂȂꍇ̓kԂB
 */

delname(char *s)
{
    char *p;
    
    p=s;
    while(*s) {
        if(*s==':' ) p=s+1;
        if(*s=='\\') p=s+1;
        s++;
    }

    if(p!=NULL) *p=0;
}

/**********************************************************************
 *   s 󔒂ŋ؂B ---> args[n]  , return (argc)
 **********************************************************************
 */
#define	is_space(c) ((c==' ')||(c=='\t'))
#define spskip(s) while(is_space(*s)) s++;
#define chskip(s) while(*s) { if(is_space(*s))break; s++; }

split_args(s,args)
char *s;
char **args;
{
	int argc=0;
	while(*s) {
		spskip(s);
		if(*s) {
			*args++ = s;
			 argc++;
			chskip(s);
			if(*s==0) break;
			*s++ = 0;
		}
	}
	return argc;
}

#if WILD_ARGS
/**********************************************************************
 *   s ChJ[h܂ނH
 **********************************************************************
 */
is_wild(s)
char *s;
{
    while(*s) {
        if(*s=='?') return 1;
        if(*s=='*') return 1;
        s++;
    }
    return 0;
}
#endif

/**********************************************************************
 *  mallocƓ̃[`imallocoȂ͒~j
 **********************************************************************
 */
static	char *xmalloc(n)
{
    char *p;

    p = malloc (n);
    if (p == NULL) {
        printf("xmalloc: Not enough memory!\n");
        exit(1);
    }
    return p;
}

/**********************************************************************
 *  malloc[ɃRs[Ã|C^Ԃ
 **********************************************************************
 */
static	char *xstrdup(char *string)
{
    return (char *) strcpy(xmalloc (strlen (string) + 1), string);
}

/**********************************************************************
 *  
 **********************************************************************
 */
/*[EOF]*/

